/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesyougo;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.GroundEffect;
import rtg.api.world.terrain.heighteffect.HeightEffect;
import rtg.api.world.terrain.heighteffect.JitterEffect;
import rtg.api.world.terrain.heighteffect.RaiseEffect;
import rtg.api.world.terrain.heighteffect.SpikeEverywhereEffect;
import rtg.api.world.terrain.heighteffect.VoronoiBorderEffect;
import rtg.world.biome.realistic.biomesyougo.RealisticBiomeBYGBase;

public class RealisticBiomeBYGTropicalIslands
extends RealisticBiomeBYGBase {
    public RealisticBiomeBYGTropicalIslands(Biome biome) {
        super(biome, RealisticBiomeBase.RiverType.NORMAL, RealisticBiomeBase.BeachType.NORMAL);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public void initDecos() {
        this.fallenTrees(new IBlockState[]{BlockUtil.getBlockStateFromCfgString("byg:mahogany_log:3", BlockUtil.getStateLog(BlockPlanks.EnumType.JUNGLE)), BlockUtil.getBlockStateFromCfgString("byg:mahogany_log:3", BlockUtil.getStateLog(BlockPlanks.EnumType.JUNGLE))}, new int[]{1, 1});
    }

    @Override
    public TerrainBase initTerrain() {
        return new RidgedExtremeHills(150.0f, 67.0f, 200.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaExtremeHills(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, 60.0f, -0.14f, 14.0f, 0.25f);
    }

    public static class SurfaceVanillaExtremeHills
    extends SurfaceBase {
        private IBlockState mixBlockTop;
        private IBlockState mixBlockFill;
        private float width;
        private float height;
        private float smallW;
        private float smallS;

        public SurfaceVanillaExtremeHills(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFill, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.mixBlockTop = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mixTop);
            this.mixBlockFill = this.getConfigBlock(config.SURFACE_MIX_FILLER_BLOCK.get(), mixFill);
            this.width = mixWidth;
            this.height = mixHeight;
            this.smallW = smallWidth;
            this.smallS = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.width, (float)j / this.width) + simplex.noise2f((float)i / this.smallW, (float)j / this.smallW) * this.smallS > this.height) {
                        primer.func_177855_a(x, k, z, this.mixBlockTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.mixBlockFill);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaExtremeHills
    extends TerrainBase {
        private float start;
        private float height;
        private float width;

        public TerrainVanillaExtremeHills(float hillStart, float landHeight, float baseHeight, float hillWidth) {
            this.start = hillStart;
            this.height = landHeight;
            this.base = baseHeight;
            this.width = hillWidth;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaExtremeHills.terrainHighland(x, y, rtgWorld, river, this.start, this.width, this.height, this.base);
        }
    }

    public static class RidgedExtremeHills
    extends TerrainBase {
        private final HeightEffect heightIncrease;
        private final HeightEffect multiplier;
        private final HeightEffect groundEffect;
        private float height;
        private float width;
        private float ridgeWidth = 300.0f;
        private float valleyFloor = -0.2f;

        public RidgedExtremeHills(float landHeight, float baseHeight, float hillWidth) {
            this.height = landHeight;
            this.base = baseHeight;
            this.width = hillWidth;
            SpikeEverywhereEffect baseHills = new SpikeEverywhereEffect();
            baseHills.spiked = new RaiseEffect(this.height * 2.0f / 3.0f);
            baseHills.wavelength = this.width;
            baseHills.minimumSimplex = -0.2f;
            baseHills.octave = 3;
            baseHills.power = 1.9f;
            SpikeEverywhereEffect additionalHeightSpikes = new SpikeEverywhereEffect();
            additionalHeightSpikes.spiked = new RaiseEffect(this.height / 3.0f);
            additionalHeightSpikes.wavelength = this.width / 3.0f;
            additionalHeightSpikes.minimumSimplex = -0.2f;
            additionalHeightSpikes.octave = 4;
            additionalHeightSpikes.power = 1.9f;
            JitterEffect additionalHeight = new JitterEffect();
            additionalHeight.amplitude = additionalHeightSpikes.wavelength / 3.0f;
            additionalHeight.wavelength = additionalHeightSpikes.wavelength / 2.0f;
            additionalHeight.jittered = additionalHeightSpikes;
            SpikeEverywhereEffect rougheningSpikes = new SpikeEverywhereEffect();
            rougheningSpikes.spiked = new RaiseEffect(this.height / 8.0f);
            rougheningSpikes.wavelength = this.width / 10.0f;
            rougheningSpikes.minimumSimplex = -0.2f;
            rougheningSpikes.octave = 5;
            rougheningSpikes.power = 1.9f;
            JitterEffect roughening = new JitterEffect();
            roughening.amplitude = rougheningSpikes.wavelength / 3.0f;
            roughening.wavelength = rougheningSpikes.wavelength / 2.0f;
            roughening.jittered = rougheningSpikes;
            JitterEffect hillJitter = new JitterEffect();
            hillJitter.amplitude = 15.0f;
            hillJitter.wavelength = 50.0f;
            hillJitter.jittered = baseHills.plus(additionalHeight).plus(roughening);
            this.heightIncrease = hillJitter;
            VoronoiBorderEffect ridging = new VoronoiBorderEffect();
            ridging.pointWavelength = this.ridgeWidth;
            ridging.floor = this.valleyFloor;
            ridging.minimumDivisor = 0.2f;
            JitterEffect ridgeJitter = new JitterEffect();
            ridgeJitter.amplitude = 15.0f;
            ridgeJitter.wavelength = 50.0f;
            ridgeJitter.jittered = ridging;
            JitterEffect ridgeJitterrette = new JitterEffect();
            ridgeJitterrette.amplitude = 5.0f;
            ridgeJitterrette.wavelength = 20.0f;
            ridgeJitterrette.jittered = ridgeJitter;
            this.multiplier = ridgeJitterrette;
            this.groundEffect = new GroundEffect(6.0f);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            float groundEffectLevel = this.groundEffect.added(rtgWorld, x, y);
            float ridging = this.multiplier.added(rtgWorld, x, y);
            ridging = TerrainBase.bayesianAdjustment(ridging, 2.0f);
            float result = this.base + ridging * (groundEffectLevel + this.heightIncrease.added(rtgWorld, x, y)) + groundEffectLevel;
            return TerrainBase.mountainCap(result);
        }
    }
}

